/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import android.os.ParcelFileDescriptor;
import android.support.annotation.RequiresApi;
import com.gprinter.utils.BitmapUtils;
import com.gprinter.utils.ZLibUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class PDFUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=21)
    public static Bitmap[] PDFToBitmap(File file, int width) throws Exception {
        if (file == null) {
            new Exception("File no exit");
            return null;
        }
        ParcelFileDescriptor mFileDescriptor = null;
        PdfRenderer mPdfRenderer = null;
        PdfRenderer.Page mCurrentPage = null;
        try {
            mFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
            if (mFileDescriptor != null) {
                mPdfRenderer = new PdfRenderer(mFileDescriptor);
            }
            int pageCount = mPdfRenderer.getPageCount();
            Bitmap[] bitmaps = new Bitmap[pageCount];
            for (int i = 0; i < pageCount; ++i) {
                if (mCurrentPage != null) {
                    mCurrentPage.close();
                }
                mCurrentPage = mPdfRenderer.openPage(i);
                int scaleWidth = (width + 7) / 8 * 8;
                int scaleHeight = mCurrentPage.getHeight() * scaleWidth / mCurrentPage.getWidth();
                Bitmap bitmap = Bitmap.createBitmap((int)scaleWidth, (int)scaleHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap.eraseColor(-1);
                mCurrentPage.render(bitmap, null, null, 1);
                bitmaps[i] = bitmap;
            }
            Bitmap[] i = bitmaps;
            return i;
        }
        catch (FileNotFoundException e) {
            new Exception("File no exit");
            Bitmap[] bitmapArray = null;
            return bitmapArray;
        }
        catch (IOException e) {
            new Exception("Parsing File no error");
            Bitmap[] bitmapArray = null;
            return bitmapArray;
        }
        finally {
            if (null != mCurrentPage) {
                mCurrentPage.close();
            }
            if (mPdfRenderer != null) {
                mPdfRenderer.close();
            }
            try {
                mFileDescriptor.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] drawEscPDF(Bitmap bitmap) {
        int bmpWidth = bitmap.getWidth() % 8;
        int width1 = bmpWidth == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        int bmpHeight = bitmap.getHeight();
        byte[] printImage = BitmapUtils.getCompressedBinaryzationBytes(bitmap, 190, true);
        byte[] data = new byte[printImage.length + 8];
        data[0] = 29;
        data[1] = 118;
        data[2] = 48;
        data[3] = 0;
        data[4] = (byte)(width1 % 256);
        data[5] = (byte)(width1 / 256);
        data[6] = (byte)(bmpHeight % 256);
        data[7] = (byte)(bmpHeight / 256);
        for (int i = 0; i < printImage.length; ++i) {
            data[i + 8] = printImage[i];
        }
        return data;
    }

    public static byte[] drawTscPDF(Bitmap bitmap) throws UnsupportedEncodingException {
        int width = bitmap.getWidth() % 8 == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        int height = bitmap.getHeight();
        String bitmapCmd = "BITMAP 0,0," + width + "," + height + ",0,";
        byte[] data = BitmapUtils.getCompressedBinaryzationBytes(bitmap, 128, false);
        int x1 = bitmap.getWidth() % 8;
        if (x1 != 0) {
            for (int x3 = 0; x3 < data.length; x3 += width) {
                int n = x3 + width - 1;
                data[n] = (byte)(data[n] | (byte)(255 >> x1));
            }
        }
        return PDFUtils.addBytes(bitmapCmd.getBytes("GB18030"), data);
    }

    public static byte[] drawTscPDFLib(Bitmap bitmap) throws UnsupportedEncodingException {
        int width = bitmap.getWidth() % 8 == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        int height = bitmap.getHeight();
        byte[] data = BitmapUtils.getCompressedBinaryzationBytes(bitmap, 190, true);
        int x1 = bitmap.getWidth() % 8;
        if (x1 != 0) {
            for (int x3 = 0; x3 < data.length; x3 += width) {
                int n = x3 + width - 1;
                data[n] = (byte)(data[n] | (byte)(255 >> x1));
            }
        }
        byte[] compressByte = new byte[]{};
        try {
            compressByte = ZLibUtils.zLib(data, 9);
        }
        catch (IOException var7) {
            var7.printStackTrace();
        }
        String bitmapCmd = "BITMAP 0,0," + width + "," + height + ",3," + compressByte.length + ",";
        return PDFUtils.addBytes(bitmapCmd.getBytes("GB18030"), compressByte);
    }

    public static byte[] addBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;
    }
}

